;SPSS for Windows Script 
;
; Author: Richard Orme
; Technical Consultant, Royal National Institute for the Blind, UK
; Email: rorme@rnib.org.uk
; WWW: www.rnib.org.uk

; Note that dates in this script are in the format dd/mm/yy

; The script file is divided into sections:
;	Version notes
;	Other notes
;	Global declarations
;	General scripts
;	Development scripts
;	Help scripts
;	Data entry grid scripts
;	Dialogue scripts
;	Output Navigator

; *** Version notes

; Note that dates in this script are in the format dd/mm/yy

; Version 14/9/99
;	changed help text for edit mode to reflect that user could enter this mode using the 
;	braille display
;	changed code that generates list box of arrow buttons to remove blank last item 

; Version 9/7/99
;	modification for SPSS version 9: changed test for whether in output viewer to reflect the 
;	changed title window
;	added support for a number of dialogues containing arrow buttons

; Version 17/6/99
;	final tidy up of script for distribution

; Version 19/5/99
;	wrote own version of StringSegment function as this is not offered in 3.2
;	users of this version can now have the full functionality of these scripts

; Version 18/5/99
;	in the arrow button list box greyed out buttons are now listed as such
;	moving the cursor in edit mode is now much more responsive

; Version 17/5/99
;	Tidied up the order of the routines in the script so that it is easier to find ones way around
;	now detects whether an arrow button is greyed or not
;	no longer attempts to move between arrow buttons when the menu is active in the dialogue

; Version 14/5/99
;	tested with large fonts selected. worked with up to 48 point arial as display font. Manual updated.

; Version 13/5/99
;	added support for versions of Jaws earlier than version 3.3
;	this now checks the Jaws version and means that while JFW 3.2 will not get arrow buttons
;	announced brilliantly, nor get the context sensitive help, or get the list box of arrow buttons
;	at least they will still be able to use SPSS in the data editor and output navigator.
;	This is because the new function StringSegment is used extensively
;	made detecting edit mode more robust
;	updated documentation
;	added a function to enter a 0 a long way down the data entry grid to make it speak a lot better 
;	as it is set up
;	made the home, end, ctrl-home and ctrl-end functions more robust

; Version 11/5/99
;	changed the folder used for the exported tables from the output navigator to c:\mydocu~1
;	if this is the default file location for Excel files, the spreadsheets will be loaded automatically
;	on ins+shift+E
;	completely re wrote the arrow button handling as I recaptured all the data in a new way and stuck
;	it in the message file. This means that I can manipulate the same data (and there is a lot of it) in a
;	number of procedures, namely announcing the button, producing a list box of arrow buttons, jumping
;	to the list box quickly and a context sensitive help system.
;	It took forever to do, but the bones are all there now and it is more reliable still. Also, if there are future
;	functions available, the same data can be used for more powerful reading features.
; 	Finally, the script could be used for other language versions of SPSS more easily.

; Version 5/4/99
;	changed code that handles left, right, up and down movements in data entry grid to wait until the
;	position changed before reading out new position. This was to solve rare but annoying problem 
;	when SPSS paused a long time before moving the cursor due to hard disk activity, resulting in the
;	cell information concerning the place you were moving from being announced, rather than your
;	new location. Unfortunately, this has not speeded up the response, which I was also hoping for.

;	Changed the order of the options in the AutomatedExtport list box as I felt that Last items was 
;	going to be chosen most of the time, so this should be the first option

;	Changed the editor for reading text output from notepad to wordpad. Sometimes the output is too
;	big to go into notepad, which resulted in a confusing dialogue for the user

; Version 9/3/99
;	added code to SpeakArrowButton and FocusChangedEvent to deal with the new list boxes used
;	in SPSS version 8. Added code to detect the colour of the highlighted item when the list box does
;	not have the focus, to cope with alternative colour schemes. The variable being posted into a list
;	box is not determined at this point (unlike in version 7.5)

; Version 8/3/99
;	added code to recognise output viewer in SPSS version 8, as this window now has a new title.

; Version 4/3/99
;	added code so that when exporting the output, the user does not have to confirm overwriting 
;	each time

; Version 25/2/99
;	added support for viewing the output in Excel- see bug list

; Version 16/2/99
;	in SayCellDetails the cell contents are no longer spoken AND spelt if there is only one character
;	made SpeakArrowButton routine more robust in dialogues where the attributes are not reported 
;	correctly, and made the procedure much easier to read.

; Version 11/2/99
;	added routines to jump to next and previous arrow buttons in dialogues
;	added routine to bring up documentation in notepad on double hit of f1

; Version 10/2/99
;	fixed bug in SpeakButtonRoutine so that the currently highlighted item is found and the purpose
;		of the arrow determined from this
;	added code to maximise the application window when it gets the focus
;	improved help text when the navigation tree arrow is not found
;	tested on new installation of SPSS on Windows NT 4 SP3
;	tested on new installation of Windows 95 (previously used on Windows 98)

; Version 12/12/98
;	wrote SpeakButtonRoutine and reworked script so these are spoken
;	SpeakArrowButton now returns true if the button is found, and no further tests are done
;	if the button is not spoken when all the tests are made, it is announced as unlabelled
;	added SayWord function so that the arrow button, pat button or cell contents are read on Ins-Num 5

; Version 11/12/98
;-	improved robustness and speed of SpeakArrowButton routine
;-	added support for all dialogues with arrow buttons reached from data and transform menus

; Version 9/12/98
;-	added routine for capturing the control ids and window titles for the dialogues using arrow buttons
;	wrote SpeakArrowButton routine for much improved voicing of arrow buttons

; Version 7/12/98
;-	added support for home, end, ctrl home, ctrl end keystrokes in data editor
;-	made some functions more robust by checking for appropriate context

; Version 6/12/98
;-	added auto export function
;-	added quick loading of editor to review output
;-	added keystrokes for re reading contents and spelling variable name
;-	refined search for info line so that this works if 0,1 or 2 toolbars are displayed
;-	added announcing of value labels to SayCellDetails
;-	added announcing of most arrow buttons in transform, data, graphs, statistics menus
;-	added announcing graphical buttons in graphs dialogues
;-	added help for output navigator

; Version 3/12/98
;-	determining cell location and contents made more robust- now based on lines from top of window
;	rather than frame which kept changing
;-	now copes with editing the current cell contents with F2
;-	announces when in the dead area of the grid
;-	announces blank on an empty cell
;-	announces arrow buttons automatically where they have been included in Function FocusChangedEvent 
;-	added test for output navigation window
;-	added funtionality to follow output navigation mode arrow, in medium and large views (works best in medium)

; *** Other Notes

;Tests
;	tested with high contrast black, and worked fine, even when the text was displayed by SPSS as white on white!
;	tested with different colours (in the Speak ArrowButton the attributes are used for locating highlights. This works fine.
;	works with toolbar off
;	works with gridlines off
;	saycelldetails works in and out of edit mode
;	tested with version 7.5 and 8.0, in various colur schemes
;	tested in hi color mode. The FindArrow routine for the output viewer does not work- perhaps if the graphic was labelled
;	when running in this mode it would be ok?

;Bugs (or "features"!)
;	arrow not tracked in navigator in small view
;	relies on windows being on c and there being a c:\windows\temp
;	sometimes (but rarely) announces in edit mode when moving in the data grid when the screen scrolls
;	cannot actually see the contents of the data grid as it is displayed (eg "2.00") although it is copied into the clipboard nicely
;	jaws needs to be running before SPSS is started, otherwise it don"t work!
;	if the graphics acceleration is not set to full (control panel/system/performance/graphics) then the script does not work
;	correctly

;Wish List
;-	some support for Verbosity settings would be nice
;-	could resize the vertical split in the output navigator with code something like
;			Dim objOutputDoc as ISpssOutputDoc
;			Set objOutputDoc = objSpssApp.GetDesignatedOutputDoc
;			' Set the Output Document window on the right half of the screen: 
;			objOutputDoc.Left = Screen.Width/2
;			' Set the splitter bar at one-fourth of the window width:
;			objOutputDoc.SplitterPosition = objOutputDoc.Width/4
;
;	It would be nice to be able to detect a running copy of SPSSWIN.DOC manual and switch to this on double ins+f1
;	rather than loading another copy.

;Notes
;-	in the data grid, ctrl-c copies text as it is displayed in the grid to the clipboard, but I can find no way 
;	of speaking this

;-	the variable description can be found in data, define variable, labels

;-	SPSS uses arrowbuttons and PatButtons, which have no text or graphic associated with them
; 	The FocusChanged routine spots these and reads them
; 	These routines require as parameters the dialogue title and control ids of a number of controls in the dialogue
; 	To capture all of these quickly and accurately, there is a routine CaptureArrowButtonStuff to grab them and form
; 	a procedure call, which was used in the production of this script. It is left in here in case it is needed in future
; 	script developments

;	Many of the custom routines rely on the dialogue titles, which means that the data in spsswin.jsm would need to all be 
;	captured for a German version of the scripts.

; Global Declarations

Include "hjglobal.jsh"
include "hjconst.jsh"
include "spsswin.jsm"

Const
	VersionDate = "September 14, 1999"

Globals

; variables used for CaptureArrowButtonStuff (arrow and pat buttons)
	string DlgTitle,		; title of the dialogue
	int DlgFrom,		; control id of the list box from which items are taken
	int DlgBtn,		; control id of the arrow button
	int DlgTo,		; control id of the destination list box or edit box
	string DlgToTitle,	; title of the destination control
	string DataLinestring,  ; this is the data as it is exported to the clipboard

; general global variables
	Int WayRound,		; whether cell contents are announced before row or column in datagrid
	int SPSSAlreadyRun, 	; to say auto start message and initialise variables only first time
	int HTMLmode,	; whether the autoexport function in output navigator exports txt or html
	string WindowTitle,	; used by Arrow and Pat Button routines
	int FocusID		; used by Arrow and Pat Button routines

; *** General Scripts


String Function StringSeg (string SourceString, string Delimiter, int Index)

var
	int FirstDelimiter

;	strip sections until target is first
	while Index > 1
		Let FirstDelimiter = StringContains (SourceString, Delimiter)
		if FirstDelimiter > 0 then
			Let SourceString = SubString (SourceString, FirstDelimiter+1, StringLength (SourceString) - FirstDelimiter)
			Let Index = Index - 1
		else
			Let SourceString = ""
			Let Index = 0
		endif
	endwhile

; now remove trailing sections
		Let FirstDelimiter = StringContains (SourceString, Delimiter)
		if FirstDelimiter > 0 then
			Let SourceString = SubString(SourceString, 1, FirstDelimiter -1)
		endif
	Return SourceString
EndFunction

Void Function AutoStartEvent ()

{Alt+Space}
{x}	

if (not SPSSAlreadyRun) then
	let SPSSAlreadyRun = true
	let HTMLmode = false
	SayString("Jaws script file for S P S S, version"+VersionDate)
	SayString ("Press insert then F1 twice quickly to load the Jaws and S P S S manual")
	SayString ("or press insert F1 for screen sensitive help at any point")
	SayString ("This script written by Richard Orme of the Royal National Institute for the Blind, United Kingdom.")
endif ; first time

EndFunction


; *** Development scripts

Script CaptureArrowButtonStuff ()
; only used during script development
; this script captures stuff as described by the notes section at the top of the file
; it sets the variable DataLineString to a line of data
; you cut and paste into this script 

Var
	string DlgTitle,
	int VarListBoxID,
	string ButtonIDs, 
	int count,
	int ArrowButtonCount,
	handle StartFrom,
	string ListBoxTitles,
	string ListBoxIDs,
	string SaveControlName

	Let DlgTitle = GetWindowName (GetRealWindow (GetFocus()))
	Let VarListBoxID = GetCurrentControlID () 

	SaveCursor ()
	JawsCursor ()
	JAWSHome ()
	JAWSHome ()

	Let ArrowButtonCount = 0

	MoveToWindow (GetFirstWindow (GetFocus ()))

	while GetNextWindow (GetCurrentWindow ()) != 0
		MoveToWindow (GetNextWindow (GetCurrentWindow ()))
		if GetWindowClass (GetCurrentWindow ()) == "ArrowButton" then
			Let ArrowButtonCount = ArrowButtonCount + 1
			Let StartFrom= GetCurrentWindow ()
			StopSpeech ()
			Delay(30)
			SetFocus (GetCurrentWindow ())
			Pause ()
			Pause ()
			if arrowButtonCount == 1 then
				Let ListBoxTitles = GetControlName ()
				Let ListBoxIDs = IntToString (GetControlID (GetCurrentWindow ()))
				Let ButtonIDs = IntToString (GetControlID (StartFrom))
			else
				Let ListBoxTitles = ListBoxTitles + "|"+GetControlName ()
				Let ListBoxIDs = ListBoxIDs + "|" + IntToString (GetControlID (GetCurrentWindow ()))
				Let ButtonIDs = ButtonIDs + "|" + IntToString (GetControlID (StartFrom))				
			endif
			MoveToWindow (Startfrom)
		endif
	endwhile

	StopSpeech ()
	SayString (IntToString (ArrowButtonCount)+" arrow buttons found")
	SayString ("With the titles "+ListBoxTitles)

	if DataLineString == "" then
		Let DataLineString = DlgTitle+"~"+IntToString(VarListBoxID)+"~"+ListBoxTitles+"~"+ButtonIDs+"~"+ListBoxIDs
	else
		Let DataLineString = DataLineString + "\r\n"+DlgTitle+"~"+IntToString(VarListBoxID)+"~"+ListBoxTitles+"~"+ButtonIDs+"~"+ListBoxIDs
	endif
	RestoreCursor ()
EndScript

Script PlaceDataLineStringInClipboard ()

	CopyToClipboard (DataLineString)
	let DataLineString = ""
	SayString ("Data lines copied to clipboard and reset to null ")

EndScript

; *** Help scripts

Script ScriptFileName ()
; announces the name of the script file name

	SayString("Jaws script file for S P S S, version"+VersionDate)
	SayString ("Press insert then F1 twice quickly to load the Jaws and S P S S manual")
	SayString ("or press insert F1 for screen sensitive help at any point")
	SayString ("This script written by Richard Orme of the Royal National Institute for the Blind, United Kingdom")
	SayString (GetAppFileName ())
	SpellString (GetAppFileName ())

EndScript

Int Function ArrowButtonDialogueHelp (string DataLine)
; if this dialogue is matched against one listed in the data lines (in the message file) then the button names are extracted
; and used to compile a context sensitive help message

var
	int count,
	int SaidAnd,
	string ButtonIDs,
	string DialogueTitle,
	string TargetTitle,
	string ListBoxNames

	let DialogueTitle = GetWindowName (GetRealWindow (GetFocus ()))
	let TargetTitle = StringSeg (DataLine, "~",1) 

	if (TargetTitle == DialogueTitle) &&  (StringLength(TargetTitle) == StringLength (DialogueTitle)) then ; in the right dialogue
		Let ButtonIDs = StringSeg (DataLine, "~",4)
		Let ListBoxNames = StringSeg (DataLine, "~",3)
		if StringSeg (ButtonIDs, "|", 2) == "" then
			SayString ("The dialogue " + DialogueTitle+" has just the one arrow button, which will add selected variables to the ")
			SayString (ListBoxNames)
			SayString ("list box")
		else
			SayString ("The dialogue " + DialogueTitle+" has a number of arrow buttons, which will add selected variables to the following list boxes ")
			let count = 1
			Let SaidAnd = 0
			; list the names of the arrow buttons/list boxes
			while StringSeg (ListBoxNames, "|", count) != ""
				SayString (StringSeg (ListBoxNames, "|", count))
				let count = count + 1
				if (StringSeg (ListBoxNames, "|", count+1) == "") && (not SaidAnd) then
					SayString (" and ")
					Let SaidAnd = 1
				endif

			endwhile
		endif
		SayString ("Select the variable that you are concerned with from the first list box in the dialogue")
		SayString ("Then you can add the selected variables to list boxes in three ways")
		SayString ("1, Press Insert F7 for a menu of list boxes,")
		SayString ("2, Tab around the dialogue to find the arrow button you want, or ")
		SayString ("3, Move between the arrow buttons using insert n and p for next and previous arrow buttons")
		SayString ("You will usually repeat this process a number of times in this dialogue to set up a calculation")
		SayString ("You can reset the dialogues back to an empty form again with the reset button")
		SayString ("which you can usually activate with alt+r")
		SayString ("To jump to the variables list box use insert l")
		SayString ("To jump quickly to the OK button use insert o")
		SayString ("If you get the message arrow button not labelled, then please send the details given")
		SayString ("to the author who should be able to fix this.")
		return 1
	else
		return 0
	endif		

EndFunction

Script ScreenSensitiveHelp (); {Insert+F1}
Var
	int ArrowFound,
	int StopIt,
	int safety

	if (IsSameScript ()) then ; load manual into wordpad
		AppFileTopic ()
		return
	EndIf

	if DialogActive () then
			if ArrowButtonDialogueHelp(Data1) then
			elif ArrowButtonDialogueHelp(Data2) then
			elif ArrowButtonDialogueHelp(Data3) then
			elif ArrowButtonDialogueHelp(Data4) then
			elif ArrowButtonDialogueHelp(Data5) then
			elif ArrowButtonDialogueHelp(Data6) then
			elif ArrowButtonDialogueHelp(Data7) then
			elif ArrowButtonDialogueHelp(Data8) then
			elif ArrowButtonDialogueHelp(data9) then
			elif ArrowButtonDialogueHelp(data10) then
			elif ArrowButtonDialogueHelp(data11) then
			elif ArrowButtonDialogueHelp(data12) then
			elif ArrowButtonDialogueHelp(data13) then
			elif ArrowButtonDialogueHelp(data14) then
			elif ArrowButtonDialogueHelp(data15) then
			elif ArrowButtonDialogueHelp(data16) then
			elif ArrowButtonDialogueHelp(data17) then
			elif ArrowButtonDialogueHelp(data18) then
			elif ArrowButtonDialogueHelp(data19) then
			elif ArrowButtonDialogueHelp(data20) then
			elif ArrowButtonDialogueHelp(data21) then
			elif ArrowButtonDialogueHelp(data22) then
			elif ArrowButtonDialogueHelp(data23) then
			elif ArrowButtonDialogueHelp(data24) then
			elif ArrowButtonDialogueHelp(data25) then
			elif ArrowButtonDialogueHelp(data26) then
			elif ArrowButtonDialogueHelp(data27) then
			elif ArrowButtonDialogueHelp(data28) then
			elif ArrowButtonDialogueHelp(data29) then
			elif ArrowButtonDialogueHelp(data30) then
			elif ArrowButtonDialogueHelp(data31) then
			elif ArrowButtonDialogueHelp(data32) then
			elif ArrowButtonDialogueHelp(data33) then
			elif ArrowButtonDialogueHelp(data34) then
			elif ArrowButtonDialogueHelp(data35) then
			elif ArrowButtonDialogueHelp(data36) then
			elif ArrowButtonDialogueHelp(data37) then
			elif ArrowButtonDialogueHelp(data38) then
			elif ArrowButtonDialogueHelp(data39) then
			elif ArrowButtonDialogueHelp(data40) then
			elif ArrowButtonDialogueHelp(data41) then
			elif ArrowButtonDialogueHelp(data42) then
			elif ArrowButtonDialogueHelp(data43) then
			elif ArrowButtonDialogueHelp(data44) then
			elif ArrowButtonDialogueHelp(data45) then
			elif ArrowButtonDialogueHelp(data46) then
			elif ArrowButtonDialogueHelp(data47) then
			elif ArrowButtonDialogueHelp(data48) then
			elif ArrowButtonDialogueHelp(data49) then
			elif ArrowButtonDialogueHelp(data50) then
			elif ArrowButtonDialogueHelp(data51) then
			elif ArrowButtonDialogueHelp(data52) then
			elif ArrowButtonDialogueHelp(data53) then
			elif ArrowButtonDialogueHelp(data54) then
			elif ArrowButtonDialogueHelp(data55) then
			elif ArrowButtonDialogueHelp(data56) then
			elif ArrowButtonDialogueHelp(data57) then
			elif ArrowButtonDialogueHelp(data58) then
			elif ArrowButtonDialogueHelp(data59) then
			elif ArrowButtonDialogueHelp(data60) then
			elif ArrowButtonDialogueHelp(data61) then
			elif ArrowButtonDialogueHelp(data62) then
			elif ArrowButtonDialogueHelp(data63) then
			elif ArrowButtonDialogueHelp(data64) then
			elif ArrowButtonDialogueHelp(data65) then
			elif ArrowButtonDialogueHelp (data66) then
			elif ArrowButtonDialogueHelp (data67) then
			elif ArrowButtonDialogueHelp (data68) then
			elif ArrowButtonDialogueHelp (data69) then
			elif ArrowButtonDialogueHelp (data70) then
			elif ArrowButtonDialogueHelp (data71) then
			elif ArrowButtonDialogueHelp (data72) then
			elif ArrowButtonDialogueHelp (data73) then
			elif ArrowButtonDialogueHelp (data74) then
			elif ArrowButtonDialogueHelp (data75) then
			elif ArrowButtonDialogueHelp (data76) then
			elif ArrowButtonDialogueHelp (data77) then
			elif ArrowButtonDialogueHelp (data78) then
			elif ArrowButtonDialogueHelp (data79) then
			elif ArrowButtonDialogueHelp (data80) then
			elif ArrowButtonDialogueHelp (data81) then
			elif ArrowButtonDialogueHelp (data82) then
			elif ArrowButtonDialogueHelp (data83) then
			elif ArrowButtonDialogueHelp (data84) then
			elif ArrowButtonDialogueHelp (data85) then
			elif ArrowButtonDialogueHelp (data86) then
			elif ArrowButtonDialogueHelp (data87) then
			elif ArrowButtonDialogueHelp (data88) then
			elif ArrowButtonDialogueHelp (data89) then
			elif ArrowButtonDialogueHelp (data90) then
			elif ArrowButtonDialogueHelp (data91) then
			elif ArrowButtonDialogueHelp (data92) then
			elif ArrowButtonDialogueHelp (data93) then
			elif ArrowButtonDialogueHelp (data94) then
			elif ArrowButtonDialogueHelp (data95) then
			elif ArrowButtonDialogueHelp (data96) then
			elif ArrowButtonDialogueHelp (data97) then
			elif ArrowButtonDialogueHelp (data98) then
			elif ArrowButtonDialogueHelp (data99) then
			elif ArrowButtonDialogueHelp (data100) then
			elif ArrowButtonDialogueHelp (data101) then
			elif ArrowButtonDialogueHelp  (data102) then
			elif ArrowButtonDialogueHelp  (data103) then
			elif ArrowButtonDialogueHelp  (data104) then
			elif ArrowButtonDialogueHelp  (data105) then
			elif ArrowButtonDialogueHelp  (data106) then
			elif ArrowButtonDialogueHelp  (data107) then
			elif ArrowButtonDialogueHelp  (data108) then
			elif ArrowButtonDialogueHelp  (data109) then
			elif ArrowButtonDialogueHelp  (data110) then
			elif ArrowButtonDialogueHelp  (data111) then
			elif ArrowButtonDialogueHelp  (data112) then
			elif ArrowButtonDialogueHelp  (data113) then
			elif ArrowButtonDialogueHelp  (data114) then
			elif ArrowButtonDialogueHelp  (data115) then
			elif ArrowButtonDialogueHelp  (data116) then
			elif ArrowButtonDialogueHelp  (data117) then
			elif ArrowButtonDialogueHelp  (data118) then
			elif ArrowButtonDialogueHelp  (data119) then
			elif ArrowButtonDialogueHelp  (data120) then
			elif ArrowButtonDialogueHelp  (data121) then
			elif ArrowButtonDialogueHelp  (data122) then
			elif ArrowButtonDialogueHelp  (data123) then
			elif ArrowButtonDialogueHelp  (data124) then
			elif ArrowButtonDialogueHelp  (data125) then
			elif ArrowButtonDialogueHelp  (data126) then
			elif ArrowButtonDialogueHelp  (data127) then
			elif ArrowButtonDialogueHelp  (data128) then
			elif ArrowButtonDialogueHelp  (data129) then
			elif ArrowButtonDialogueHelp  (data130) then
			elif ArrowButtonDialogueHelp  (data131) then
			elif ArrowButtonDialogueHelp  (data132) then
			elif ArrowButtonDialogueHelp  (data133) then
			elif ArrowButtonDialogueHelp  (data134) then
			elif ArrowButtonDialogueHelp  (data135) then
			elif ArrowButtonDialogueHelp  (data136) then
			elif ArrowButtonDialogueHelp  (data137) then
			elif ArrowButtonDialogueHelp  (data138) then
			elif ArrowButtonDialogueHelp  (data139) then
			elif ArrowButtonDialogueHelp  (data140) then
			elif ArrowButtonDialogueHelp  (data141) then
			elif ArrowButtonDialogueHelp  (data142) then
			elif ArrowButtonDialogueHelp  (data143) then
			elif ArrowButtonDialogueHelp  (data144) then
			elif ArrowButtonDialogueHelp  (data145) then
			elif ArrowButtonDialogueHelp  (data146) then
			elif ArrowButtonDialogueHelp  (data147) then
			elif ArrowButtonDialogueHelp  (data148) then
			elif ArrowButtonDialogueHelp  (data149) then
			elif ArrowButtonDialogueHelp  (data150) then
			endif	
	endif

	if InDataGrid () then
		SayString ("You are in the data entry grid.")
		SayString ("Use the arrow keys to move around the grid.")
		SayString ("Use Insert C to hear the contents of the current cell.")
		SayString ("Use Insert, A to change the order of announcements as you move around the grid")
		SayString ("Use home and end to move to the first and last column.")
		SayString ("Control home will move to the first row, first variable,")
		SayString ("To move to the last variable of the last row, use control end.")
		SayString ("Shift spacebar will select the current row,")
		SayString ("To select the current variable use control spacebar.")
		SayString ("You can search for data with alt f5.")
		SayString ("If the variable has value labels set, you can access these with shift f2")
		SayString ("Press insert f1 twice quickly to read full documentation")
	endif

	if InOutputNavigator () then
		SayString ("You are in the output navigator")
		SayString ("You may be able to move through a tree view of the output that you")
		SayString ("have created from SPSS using the up and down keys.")
		SayString ("To view the output easily, export the tables using Insert E")
		SayString ("Then run the editor program with Insert Shift E")
		SayString ("Text mode is easiest for reviewing the tables. You can switch between")
		SayString ("Text and HTML mode with Insert M.")
		SayString ("Once in the editor, review your output, and if required save, print or braille it.")
		SayString ("Press insert f1 twice quickly to read full documentation")
	endif

EndScript

Void Function EditModePrompt ()
; Warns the user that they are in edit mode rather than moving round the data grid

	SayString ("Edit mode, press enter to confirm changes or escape then enter to exit")
	SayString ("Use edit mode to change the contents of a cell")

EndFunction

; *** Data entry grid scripts

Script MoveDownLoadsofCases ()
var
   int JumpCount,
   int count,
   string  messagestring

	; display help text in message box
	Let messagestring = "You can use this function to make the data entry grid speak a lot better when you are setting it up. \r\n\n"
	Let messagestring = messagestring + "If you are already working with entered data, then press escape twice now to abort this.\r\n\n"
	Let messagestring = messagestring + "Choose the number of rows you want setting up. \r\n\n"
	Let messagestring = messagestring + "The data grid will then speak much better when you are entering real information."
	MessageBox (messagestring)

	let count = 0
	if InDataGrid () && not MenusActive () && not DialogActive () then
		Let JumpCount = DlgSelectItemInList ("10|40|90|160|250", "How many rows down shall I move?", false) 
		Let JumpCount = (JumpCount * JumpCount) * 10
		if not JumpCount == 0 then
		MessageBox ("If you picked a large number, this could take up to a minute, during which there will be no speech output.")
			{ctrl+end}
			while count < JumpCount
				{down arrow}
				let count = count + 1
				pause()
			endwhile
			{0}
			{enter}
			Pause()
			{up arrow}
			{delete}
			{enter}
			Pause()
			{enter}
			{ctrl end}
			SayString ("You may now need to delete the 0 from the last row in the last column.")
			SayString ("You can get to this with control end.")
		endif
	endif		

EndScript

Int Function InDataGrid ()
; This function tests to see if the user is in the data entry grid. 
; the first condition is for the right window open
; the second that we are not in a menu
; the third that we are not in a dialogue

	if StringContains (GetWindowName (GetAppMainWindow (getfocus())), "Data Editor")  && 
	   (MenusActive () == False) &&
	   (DialogActive () == False) then
		Return 1
	else
		Return  0
	endif
EndFunction

Script SwitchWayRound ()
; toggles the announcement of cell contents first, last (see user documentation)

	if InDataGrid () then
		If WayRound == 0 then
			Let WayRound = 1
			SayString ("Announce contents last")
		Else
			Let WayRound = 0
			SayString ("Announce contents first")
		Endif
	endif
EndScript

String Function GetInfoLine ()
; finds and returns line above the datagrid that contain the variable name, row number and cell contents 

var
	string infoline 

	; up to the top, and skip the title bar and menu line
	InvisibleCursor ()
	JAWSPageUp ()
	JAWSHome ()
	NextLine ()
	NextLine ()

	; now look down the next few lines for the line containing the cell details
	if StringContains (GetLine (), ":") == 0 then
		NextLine ()
	endif
	if StringContains (GetLine (), ":") == 0 then
		NextLine ()
	endif
	if StringContains (GetLine (), ":") == 0 then
		NextLine ()
	endif
	if StringContains (GetLine (), ":") == 0 then
		NextLine ()
	endif
	let infoline = GetLine()
	PcCursor ()
	return infoline
EndFunction

String Function GetRow ()
; returns the row number by manipulating the infoline

var
	Int ColonPosition,
	string ThisLine

	Let Thisline = GetInfoLine ()
	Let ColonPosition = StringContains (ThisLine, ":")
	return SubString (ThisLine, 1, ColonPosition-1)
EndFunction

String Function GetVariable ()
; returns the variable (column) name by manipulating the infoline

var
	Int SpacePosition,
	Int VariablePosition,
	string ThisLine

	Let Thisline = GetInfoLine ()
	Let VariablePosition = StringContains (ThisLine, ":")+ 1
	Let SpacePosition = StringContains (ThisLine, " ")

	return SubString (ThisLine, VariablePosition, SpacePosition-VariablePosition)
EndFunction

String Function GetContents ()
; returns the contents of the current cell by manipulating the InfoLine string

var
	Int safety,
	string CellContents,
	string ThisLine,
	string ThisCh

	Let Thisline = GetInfoLine ()
	Let CellContents = ""
	Let safety =StringLength (ThisLine)
	While (safety > 0 )
		Let ThisCh = SubString (ThisLine, safety,1)
		if ThisCh == " " then
			Let safety = 0
		else
			Let CellContents = ThisCh+CellContents 
			Let safety = safety -1
		endif
		if CellContents == "" then
			let CellContents = "Blank"
		endif
	EndWhile
	return CellContents

EndFunction

Void Function SayCellContentsAndReference (string CellContentStr, string CellRefStr)
; announces the cell contents and row/variable, the order of which depends on the WayRound variable

Var
	object oSPSS; the application object

	if CellContentStr == " " then
		Let CellContentStr = "Blank"
;		BrailleString ("")
	endif

	If WayRound == 0 then
		SayString (CellRefStr)
		SayString (CellContentStr)
;		BrailleString ("lllll")
	Else
		SayString (CellContentStr)
		SayString (CellRefStr)
	Endif

EndFunction

Script SayCellDetails ()
; announces the cell contents, reads and spells the variable name, if there is a label then this is announced, then announces the row

Var
	string VariableString,
	string ContentsString,
	string Valuelabel,
	string RowString

	if InDataGrid () then
		if StringContains(GetInfoLine(), ":") == 0 then
			SayString ("As this variable is undefined, or no data has been entered on this row, I cannot report")
			SayString ("the cursor location.")
		Else
			Let ContentsString = GetContents()
			Let VariableString = GetVariable ()
			Let RowString = GetRow ()
			speechoff()
			{shift-F2}
			pause()
			If GetObjectTypeCode () == WT_LISTBOX then 	; list box has popped up
				if GetCharacterAttributes () == 66 then 	; there is a highlighted item
					let Valuelabel = GetLine ()
				else
					let Valuelabel = "Out of label range"
				endif
				{Esc}
				pause()
			else
				let Valuelabel = ""
			endif
			speechon()
			SayString("The cell contents is "+ContentsString)
			if Valuelabel != "" then
				SayString ("The value label is "+Valuelabel)
			endif
			SayString("The variable name is "+ VariableString)
			SpellString (VariableString)
			SayString("You are on row "+RowString)
		Endif
	endif
EndScript

Void Function SpeakRowMove ()
; on an up or down, reads the cell contents and row number

	if StringContains(GetInfoLine(), ":") == 0 then
		SayString ("No variable or data entered in this position")
	else
 		SayCellContentsAndReference("Row "+GetRow(),GetContents())
	endif
EndFunction

Void Function SpeakColumnMove ()
; on an left or right, reads the cell contents and variable name 

	if StringContains(GetInfoLine(), ":") == 0 then
		SayString ("No variable or data entered in this position")
	else
		SayCellContentsAndReference("Variable "+GetVariable(),GetContents())
	endif
EndFunction

Script SayPriorLine ()
; handles up arrow

var
	string InfoBeforeMove,
	int safety

	if InDataGrid() &&
	    (GetActiveCursor () == 1) &&				; PC Cursor
	    (GetObjectTypeCode () != WT_LISTBOX) then 	; list box has popped up
		Let InfoBeforeMove = GetInfoLine()
		Let safety = 0
		{up arrow}
		while (InfoBeforeMove == GetInfoLine()) && (safety < 10) ; wait until the row changes
			let safety = safety + 1
			pause()
		endwhile

; If there isn't a caret visible, or the row/col has changed, or there is no location on the info line, then not in edit mode

		if not CaretVisible () | (InfoBeforeMove != GetInfoLine()) | (StringContains(GetInfoLine(), ":") == 0) then
			SpeakRowMove()
		else
			SayCharacter ()
			EditModePrompt ()
		endif
	ElIf InOutputNavigator() &&
	    (GetActiveCursor () == 1) then
		{up arrow}
		Pause ()
		PerformScript FindArrow()
	else
		performscript SayPriorLine()
	endif
EndScript

Script SayNextLine ()
; handles down arrow

var
	string InfoBeforeMove,
	int safety

	if  (InDataGrid()) &&
	    (GetActiveCursor () == 1) &&				; PC Cursor cursor is on
	    (GetObjectTypeCode () != WT_LISTBOX) then 	; not in a list box 
		Let InfoBeforeMove = GetInfoLine()
		Let safety = 0
		{down arrow}
		while (InfoBeforeMove == GetInfoLine()) && (safety < 10) ; wait until the row changes
			let safety = safety + 1
			pause()
		endwhile

; If there isn't a caret visible, or the row/col has changed, or there is no location on the info line, then not in edit mode

		if not CaretVisible () | (InfoBeforeMove != GetInfoLine()) | (StringContains(GetInfoLine(), ":") == 0) then
			SpeakRowMove()
		else
			SayCharacter ()
			EditModePrompt ()
		endif
	ElIf InOutputNavigator() &&
	    (GetActiveCursor () == 1) then
		{down arrow}
		Pause ()
		PerformScript FindArrow()
	else
		performscript saynextline()
	endif
EndScript

Script JawsHome ()
; handles the home key
var
	string InfoBeforeMove,
	int safety

	if InDataGrid() &&
	    (GetActiveCursor () == 1) &&				; PC Cursor
	    (GetObjectTypeCode () != WT_LISTBOX) then 	; list box has popped up
		Let InfoBeforeMove = GetInfoLine()
		Let safety = 0
		{Home}
		SayString ("first column")
		while (InfoBeforeMove == GetInfoLine()) && (safety < 10) ; wait until the column changes
			let safety = safety + 1
			pause()
		endwhile

; If there isn't a caret visible, or the row/col has changed, or there is no location on the info line, then not in edit mode

		if not CaretVisible () | (InfoBeforeMove != GetInfoLine()) | (StringContains(GetInfoLine(), ":") == 0) then
			SpeakColumnMove()
		else
			SayCharacter ()
			EditModePrompt ()
		endif
	else
		performscript JawsHome()
	endif
EndScript

Script TopOfFile ()
var
	string InfoBeforeMove,
	int safety

	if InDataGrid() &&
	    (GetActiveCursor () == 1) &&				; PC Cursor
	    (GetObjectTypeCode () != WT_LISTBOX) then 	; list box has popped up
		Let InfoBeforeMove = GetInfoLine()
		Let safety = 0
		{Ctrl-Home}
		SayString ("first column, first row")
		while (InfoBeforeMove == GetInfoLine()) && (safety < 10) ; wait until the column changes
			let safety = safety + 1
			pause()
		endwhile

; If there isn't a caret visible, or the row/col has changed, or there is no location on the info line, then not in edit mode

		if not CaretVisible () | (InfoBeforeMove != GetInfoLine()) | (StringContains(GetInfoLine(), ":") == 0) then
			SpeakColumnMove()
		else
			SayCharacter ()
			EditModePrompt ()
		endif
	else
		performscript TopOfFile()
	endif
EndScript


Script BottomOfFile ()
var
	string InfoBeforeMove,
	int safety

	if InDataGrid() &&
	    (GetActiveCursor () == 1) &&				; PC Cursor
	    (GetObjectTypeCode () != WT_LISTBOX) then 	; list box has popped up
		Let InfoBeforeMove = GetInfoLine()
		Let safety = 0
		{Ctrl-End}
		SayString ("last column, last row")
		while (InfoBeforeMove == GetInfoLine()) && (safety < 10) ; wait until the column changes
			let safety = safety + 1
			pause()
		endwhile

; If there isn't a caret visible, or the row/col has changed, or there is no location on the info line, then not in edit mode

		if not CaretVisible () | (InfoBeforeMove != GetInfoLine()) | (StringContains(GetInfoLine(), ":") == 0) then
			SpeakColumnMove()
		else
			SayCharacter ()
			EditModePrompt ()
		endif
	else
		performscript BottomOfFile()
	endif
EndScript

Script JawsEnd ()
var
	string InfoBeforeMove,
	int safety

	if InDataGrid() &&
	    (GetActiveCursor () == 1) &&				; PC Cursor
	    (GetObjectTypeCode () != WT_LISTBOX) then 	; list box has popped up
		Let InfoBeforeMove = GetInfoLine()
		Let safety = 0
		{End}
		SayString ("last column")
		while (InfoBeforeMove == GetInfoLine()) && (safety < 10) ; wait until the column changes
			let safety = safety + 1
			pause()
		endwhile

; If there isn't a caret visible, or the row/col has changed, or there is no location on the info line, then not in edit mode

		if not CaretVisible () | (InfoBeforeMove != GetInfoLine()) | (StringContains(GetInfoLine(), ":") == 0) then
			SpeakColumnMove()
		else
			SayCharacter ()
			EditModePrompt ()
		endif
	else
		performscript JawsEnd()
	endif
EndScript

Script SayPriorCharacter ()

var
	string InfoBeforeMove,
	int ColBeforeMove,
	int safety

	if InDataGrid() &&
	    (GetActiveCursor () == 1) &&				; PC Cursor
	    (GetObjectTypeCode () != WT_LISTBOX) then 	; list box has popped up
		Let InfoBeforeMove = GetInfoLine()
		Let safety = 0
		Let ColBeforeMove = GetCursorCol ()
		{left arrow}
		while (InfoBeforeMove == GetInfoLine()) && ; the info line hasn't changed 
			(ColBeforeMove == GetCursorCol()) && ; the cursor position hasn't changed
			(safety < 10) ; timeout
			let safety = safety + 1
			pause()
		endwhile

; If there isn't a caret visible, or the row/col has changed, or there is no location on the info line, then not in edit mode

		if not CaretVisible () | (InfoBeforeMove != GetInfoLine()) | (StringContains(GetInfoLine(), ":") == 0) then
			SpeakColumnMove()
		else
			SayCharacter ()
			EditModePrompt ()
		endif
	else
		performscript SayPriorCharacter ()
	endif
EndScript


Script SayNextCharacter ()

var
	string InfoBeforeMove,
	int ColBeforeMove,
	int safety

	if InDataGrid() &&
	    (GetActiveCursor () == 1) &&				; PC Cursor
	    (GetObjectTypeCode () != WT_LISTBOX) then 	; list box has popped up
		Let InfoBeforeMove = GetInfoLine()
		Let safety = 0
		Let ColBeforeMove = GetCursorCol ()
		{right arrow}
		while (InfoBeforeMove == GetInfoLine()) && ; the info line hasn't changed 
			(ColBeforeMove == GetCursorCol()) && ; the cursor position hasn't changed
			(safety < 10) ; timeout
			let safety = safety + 1
			pause()
		endwhile

; If there isn't a caret visible, or the row/col has changed, or there is no location on the info line, then not in edit mode

		if not CaretVisible () | (InfoBeforeMove != GetInfoLine()) | (StringContains(GetInfoLine(), ":") == 0) then
			SpeakColumnMove()
		else
			SayCharacter ()
			EditModePrompt ()
		endif
	else
		performscript SayNextCharacter ()
	endif
EndScript

Script SayWord ()
	if GetWindowClass (GetFocus ()) == "ArrowButton" ||
	   GetWindowClass (GetFocus ()) == "PatButton" then
		FocusChangedEvent ()		; read the arrow or pat button
	elif InDataGrid() &&
	    (GetActiveCursor () == 1) &&				; PC Cursor
	    (GetObjectTypeCode () != WT_LISTBOX) then 	; list box has popped up
		PerformScript SayCellDetails ()		; announce the cell contents
	else
		SayWord ()
	endif
EndScript


; *** Dialogue scripts

Int Function SpeakArrowButton (string DataLine)
; this function is passed each data line in turn (as included from the message file)
; the dialogue title is then tested
; each the id of each button is then checked against those in the data line, and the correct prompt spoken

Var
	int ButtonIndex,
	string ButtonIDs,
	string ListBoxNames

	Let ButtonIndex = 1
	Let ButtonIDs = StringSeg (DataLine, "~",4)
	Let ListBoxNames = StringSeg (DataLine, "~",3)

	if StringSeg (DataLine, "~",1) == WindowTitle then ; in the right dialogue
		while StringToInt (StringSeg (ButtonIDs, "|",ButtonIndex)) > 0 ; there is another ButtonID to examine
			if FocusID == StringToInt (StringSeg (ButtonIDs, "|",ButtonIndex)) then ; on the right button
				SayString (StringSeg (ListBoxNames, "|",ButtonIndex) + " arrow button")
				if IsWindowDisabled (GetCurrentWindow ()) then ; the dialogue title bar becomes unselected if the arrow button is greyed
					SayString ("greyed")
				endif
				return 1
			else
				Let ButtonIndex = ButtonIndex + 1
			endif
		endwhile
	else
		return 0
	endif
EndFunction

Int Function SpeakPatButton (string PDlgTitle, int PControlID, string PSpeakString)
; Pat buttons are used in the graph dialogues, and are selected in a similar way to radio buttons. This script voices them.
; the function is called mainly from FocusChanged

	if  WindowTitle == PDlgTitle then
		if FocusID == PControlID then
			SayString (PSpeakString)
			return 1
		else
			return 0
		endif
	endif
EndFunction

Int Function ListBoxMenu (string DataLine)
; this procedure creates a list box of the arrow button/list box names in the dialogue
; If the user selects an item then the appropriate button is pressed 

Var
	string DTitle, 
	int ListBoxID, 
	string MenuOptions, 
	string ButtonIDs,
	int ChosenId,
	int OptionPicked,
	handle WindowFound,
	handle StartHandle,
	int StopLoop, 
	int count,
	string MsgTxt

	Let WindowTitle = GetWindowName (GetRealWindow (GetFocus ()))
	Let FocusID = GetControlID (GetFocus ()) 
	Let StartHandle = GetFocus ()
	Let DTitle = StringSeg (DataLine, "~",1)
	Let ListBoxID = StringToInt (StringSeg (DataLine, "~",2))

	if  (WindowTitle == DTitle) then ; in the right dialogue
		if (FocusID == ListBoxID) then ; in the right list box
			Let ButtonIDs = StringSeg (DataLine, "~",4)
			Let Count = 1
			Let MenuOptions = ""
			SaveCursor ()
			InvisibleCursor ()

			; move through each of the buttons, detecting if each one is disabled or not
			; the relevent option in the list box items has "- greyed" added if appropriate

			while StringSeg (ButtonIDs, "|",count) != ""
				MoveToControl (GetRealWindow (GetFocus ()), StringToInt (StringSeg (ButtonIDs, "|",count))) 
				if IsWindowDisabled (GetCurrentWindow ()) then
					Let MenuOptions = MenuOptions + StringSeg(StringSeg (DataLine, "~",3),"|",count)+"- greyed|"
				else
					Let MenuOptions = MenuOptions + StringSeg(StringSeg (DataLine, "~",3),"|",count)+"|"
				endif
				let count = count + 1
			endwhile

			; remove the trailing |
			Let MenuOptions = StringLeft (MenuOptions, StringLength (MenuOptions)-1)

			RestoreCursor ()

			; the idea of the loop is that the user can cycle round until they select a valid option or press escape
			; in practice, the list box often does not appear on the second iteration

			Let StopLoop = 0
			while not StopLoop
				Let OptionPicked = DlgSelectItemInList (MenuOptions, "Post selected variables into?", FALSE)
				if (OptionPicked > 0) then ; escape not pressed
					Let ChosenID = StringToInt (StringSeg (ButtonIDs, "|",OptionPicked))
					pause()
					SaveCursor ()
					StopSpeech ()

					; move the Jaws cursor to the selected button
					JAWSCursor ()
					MoveToControl (GetRealWindow (GetFocus ()), ChosenId) 

					if IsWindowDisabled (GetCurrentWindow ()) then
						SayString ("Sorry, this arrow button is greyed at the moment" ); loop again, hopefully
						PcCursor ()
						Pause ()
					else
						Let StopLoop = 1
						LeftMouseButton ()
						SetFocus (StartHandle) 
						{home}
						pause()
						StopSpeech ()

						; now try to get the focus sorted
						JAWSPageUp ()
						JAWSHome ()
						LeftMouseButton () ; ensures that the dialogue has the proper focus when back in SPSS
						Pause ()
						if MenusActive () then
							{escape}
						endif
						RestoreCursor ()
						Pause ()
						if MenusActive () then
							{escape}
						endif
						Pause ()
						StopSpeech ()
						SayString ("OK")
						return 1 ; attempted click on button
					endif
				else ; escape pressed
					Let StopLoop = 1
					return -1 ; escape pressed
				endif
			endwhile
		endif ; in the right list box
	endif ; in the right dialogue

	return 0 ; not me

EndFunction

Int Function JumpToVariableListBox (string DataLine)
; this procedure allows the user to quickly route to the variable list box

	SaveCursor ()
	if StringSeg (DataLine, "~",1) == GetWindowName (GetRealWindow (GetFocus ())) then ; in the right dialogue
		LeftMouseButton () ; ensures that the dialogue has the proper focus when back in SPSS
		MoveToControl (GetRealWindow (GetFocus ()), StringToInt (StringSeg (DataLine, "~",2)))
		LeftMouseButton ()
		RestoreCursor ()
		return 1
	else
		return 0
	endif
EndFunction

Script HandleJumpToVariableListBox ()
; this procedure allows the user to quickly route to the variable list box

	if not MenusActive () then
		if JumpToVariableListBox (Data1) then
		elif JumpToVariableListBox (Data2) then
		elif JumpToVariableListBox (Data3) then
		elif JumpToVariableListBox (Data4) then
		elif JumpToVariableListBox (Data5) then
		elif JumpToVariableListBox (Data6) then
		elif JumpToVariableListBox (Data7) then
		elif JumpToVariableListBox (Data8) then
		elif JumpToVariableListBox (data9) then
		elif JumpToVariableListBox (data10) then
		elif JumpToVariableListBox (data11) then
		elif JumpToVariableListBox (data12) then
		elif JumpToVariableListBox (data13) then
		elif JumpToVariableListBox (data14) then
		elif JumpToVariableListBox (data15) then
		elif JumpToVariableListBox (data16) then
		elif JumpToVariableListBox (data17) then
		elif JumpToVariableListBox (data18) then
		elif JumpToVariableListBox (data19) then
		elif JumpToVariableListBox (data20) then
		elif JumpToVariableListBox (data21) then
		elif JumpToVariableListBox (data22) then
		elif JumpToVariableListBox (data23) then
		elif JumpToVariableListBox (data24) then
		elif JumpToVariableListBox (data25) then
		elif JumpToVariableListBox (data26) then
		elif JumpToVariableListBox (data27) then
		elif JumpToVariableListBox (data28) then
		elif JumpToVariableListBox (data29) then
		elif JumpToVariableListBox (data30) then
		elif JumpToVariableListBox (data31) then
		elif JumpToVariableListBox (data32) then
		elif JumpToVariableListBox (data33) then
		elif JumpToVariableListBox (data34) then
		elif JumpToVariableListBox (data35) then
		elif JumpToVariableListBox (data36) then
		elif JumpToVariableListBox (data37) then
		elif JumpToVariableListBox (data38) then
		elif JumpToVariableListBox (data39) then
		elif JumpToVariableListBox (data40) then
		elif JumpToVariableListBox (data41) then
		elif JumpToVariableListBox (data42) then
		elif JumpToVariableListBox (data43) then
		elif JumpToVariableListBox (data44) then
		elif JumpToVariableListBox (data45) then
		elif JumpToVariableListBox (data46) then
		elif JumpToVariableListBox (data47) then
		elif JumpToVariableListBox (data48) then
		elif JumpToVariableListBox (data49) then
		elif JumpToVariableListBox (data50) then
		elif JumpToVariableListBox (data51) then
		elif JumpToVariableListBox (data52) then
		elif JumpToVariableListBox (data53) then
		elif JumpToVariableListBox (data54) then
		elif JumpToVariableListBox (data55) then
		elif JumpToVariableListBox (data56) then
		elif JumpToVariableListBox (data57) then
		elif JumpToVariableListBox (data58) then
		elif JumpToVariableListBox (data59) then
		elif JumpToVariableListBox (data60) then
		elif JumpToVariableListBox (data61) then
		elif JumpToVariableListBox (data62) then
		elif JumpToVariableListBox (data63) then
		elif JumpToVariableListBox (data64) then
		elif JumpToVariableListBox (data65) then
		elif JumpToVariableListBox(data66) then
		elif JumpToVariableListBox(data67) then
		elif JumpToVariableListBox(data68) then
		elif JumpToVariableListBox(data69) then
		elif JumpToVariableListBox(data70) then
		elif JumpToVariableListBox(data71) then
		elif JumpToVariableListBox(data72) then
		elif JumpToVariableListBox(data73) then
		elif JumpToVariableListBox(data74) then
		elif JumpToVariableListBox(data75) then
		elif JumpToVariableListBox(data76) then
		elif JumpToVariableListBox(data77) then
		elif JumpToVariableListBox(data78) then
		elif JumpToVariableListBox(data79) then
		elif JumpToVariableListBox(data80) then
		elif JumpToVariableListBox(data81) then
		elif JumpToVariableListBox(data82) then
		elif JumpToVariableListBox(data83) then
		elif JumpToVariableListBox(data84) then
		elif JumpToVariableListBox(data85) then
		elif JumpToVariableListBox(data86) then
		elif JumpToVariableListBox(data87) then
		elif JumpToVariableListBox(data88) then
		elif JumpToVariableListBox(data89) then
		elif JumpToVariableListBox(data90) then
		elif JumpToVariableListBox(data91) then
		elif JumpToVariableListBox(data92) then
		elif JumpToVariableListBox(data93) then
		elif JumpToVariableListBox(data94) then
		elif JumpToVariableListBox(data95) then
		elif JumpToVariableListBox(data96) then
		elif JumpToVariableListBox(data97) then
		elif JumpToVariableListBox(data98) then
		elif JumpToVariableListBox(data99) then
		elif JumpToVariableListBox(data100) then
		elif JumpToVariableListBox (data101) then
		elif JumpToVariableListBox (data102) then
		elif JumpToVariableListBox (data103) then
		elif JumpToVariableListBox (data104) then
		elif JumpToVariableListBox (data105) then
		elif JumpToVariableListBox (data106) then
		elif JumpToVariableListBox (data107) then
		elif JumpToVariableListBox (data108) then
		elif JumpToVariableListBox (data109) then
		elif JumpToVariableListBox (data110) then
		elif JumpToVariableListBox (data111) then
		elif JumpToVariableListBox (data112) then
		elif JumpToVariableListBox (data113) then
		elif JumpToVariableListBox (data114) then
		elif JumpToVariableListBox (data115) then
		elif JumpToVariableListBox (data116) then
		elif JumpToVariableListBox (data117) then
		elif JumpToVariableListBox (data118) then
		elif JumpToVariableListBox (data119) then
		elif JumpToVariableListBox (data120) then
		elif JumpToVariableListBox (data121) then
		elif JumpToVariableListBox (data122) then
		elif JumpToVariableListBox (data123) then
		elif JumpToVariableListBox (data124) then
		elif JumpToVariableListBox (data125) then
		elif JumpToVariableListBox (data126) then
		elif JumpToVariableListBox (data127) then
		elif JumpToVariableListBox (data128) then
		elif JumpToVariableListBox (data129) then
		elif JumpToVariableListBox (data130) then
		elif JumpToVariableListBox (data131) then
		elif JumpToVariableListBox (data132) then
		elif JumpToVariableListBox (data133) then
		elif JumpToVariableListBox (data134) then
		elif JumpToVariableListBox (data135) then
		elif JumpToVariableListBox (data136) then
		elif JumpToVariableListBox (data137) then
		elif JumpToVariableListBox (data138) then
		elif JumpToVariableListBox (data139) then
		elif JumpToVariableListBox (data140) then
		elif JumpToVariableListBox (data141) then
		elif JumpToVariableListBox (data142) then
		elif JumpToVariableListBox (data143) then
		elif JumpToVariableListBox (data144) then
		elif JumpToVariableListBox (data145) then
		elif JumpToVariableListBox (data146) then
		elif JumpToVariableListBox (data147) then
		elif JumpToVariableListBox (data148) then
		elif JumpToVariableListBox (data149) then
		elif JumpToVariableListBox (data150) then
		else
			SayString ("Could not jump to the variable list box!")
		endif
	else
			SayString ("You cannot use this function with the menus active!")
	endif
EndScript

Script PostIntoListBox ()

	if not MenusActive () then
		if ListBoxMenu (Data1) then
		elif ListBoxMenu (Data2) then
		elif ListBoxMenu (Data3) then
		elif ListBoxMenu (Data4) then
		elif ListBoxMenu (Data5) then
		elif ListBoxMenu (Data6) then
		elif ListBoxMenu (Data7) then
		elif ListBoxMenu (Data8) then
		elif ListBoxMenu (data9) then
		elif ListBoxMenu (data10) then
		elif ListBoxMenu (data11) then
		elif ListBoxMenu (data12) then
		elif ListBoxMenu (data13) then
		elif ListBoxMenu (data14) then
		elif ListBoxMenu (data15) then
		elif ListBoxMenu (data16) then
		elif ListBoxMenu (data17) then
		elif ListBoxMenu (data18) then
		elif ListBoxMenu (data19) then
		elif ListBoxMenu (data20) then
		elif ListBoxMenu (data21) then
		elif ListBoxMenu (data22) then
		elif ListBoxMenu (data23) then
		elif ListBoxMenu (data24) then
		elif ListBoxMenu (data25) then
		elif ListBoxMenu (data26) then
		elif ListBoxMenu (data27) then
		elif ListBoxMenu (data28) then
		elif ListBoxMenu (data29) then
		elif ListBoxMenu (data30) then
		elif ListBoxMenu (data31) then
		elif ListBoxMenu (data32) then
		elif ListBoxMenu (data33) then
		elif ListBoxMenu (data34) then
		elif ListBoxMenu (data35) then
		elif ListBoxMenu (data36) then
		elif ListBoxMenu (data37) then
		elif ListBoxMenu (data38) then
		elif ListBoxMenu (data39) then
		elif ListBoxMenu (data40) then
		elif ListBoxMenu (data41) then
		elif ListBoxMenu (data42) then
		elif ListBoxMenu (data43) then
		elif ListBoxMenu (data44) then
		elif ListBoxMenu (data45) then
		elif ListBoxMenu (data46) then
		elif ListBoxMenu (data47) then
		elif ListBoxMenu (data48) then
		elif ListBoxMenu (data49) then
		elif ListBoxMenu (data50) then
		elif ListBoxMenu (data51) then
		elif ListBoxMenu (data52) then
		elif ListBoxMenu (data53) then
		elif ListBoxMenu (data54) then
		elif ListBoxMenu (data55) then
		elif ListBoxMenu (data56) then
		elif ListBoxMenu (data57) then
		elif ListBoxMenu (data58) then
		elif ListBoxMenu (data59) then
		elif ListBoxMenu (data60) then
		elif ListBoxMenu (data61) then
		elif ListBoxMenu (data62) then
		elif ListBoxMenu (data63) then
		elif ListBoxMenu (data64) then
		elif ListBoxMenu (data65) then
		elif ListBoxMenu (data66) then
		elif ListBoxMenu (data67) then
		elif ListBoxMenu (data68) then
		elif ListBoxMenu (data69) then
		elif ListBoxMenu (data70) then
		elif ListBoxMenu (data71) then
		elif ListBoxMenu (data72) then
		elif ListBoxMenu (data73) then
		elif ListBoxMenu (data74) then
		elif ListBoxMenu (data75) then
		elif ListBoxMenu (data76) then
		elif ListBoxMenu (data77) then
		elif ListBoxMenu (data78) then
		elif ListBoxMenu (data79) then
		elif ListBoxMenu (data80) then
		elif ListBoxMenu (data81) then
		elif ListBoxMenu (data82) then
		elif ListBoxMenu (data83) then
		elif ListBoxMenu (data84) then
		elif ListBoxMenu (data85) then
		elif ListBoxMenu (data86) then
		elif ListBoxMenu (data87) then
		elif ListBoxMenu (data88) then
		elif ListBoxMenu (data89) then
		elif ListBoxMenu (data90) then
		elif ListBoxMenu (data91) then
		elif ListBoxMenu (data92) then
		elif ListBoxMenu (data93) then
		elif ListBoxMenu (data94) then
		elif ListBoxMenu (data95) then
		elif ListBoxMenu (data96) then
		elif ListBoxMenu (data97) then
		elif ListBoxMenu (data98) then
		elif ListBoxMenu (data99) then
		elif ListBoxMenu (data100) then
		elif ListBoxMenu (data101) then
		elif ListBoxMenu (data102) then
		elif ListBoxMenu (data103) then
		elif ListBoxMenu (data104) then
		elif ListBoxMenu (data105) then
		elif ListBoxMenu (data106) then
		elif ListBoxMenu (data107) then
		elif ListBoxMenu (data108) then
		elif ListBoxMenu (data109) then
		elif ListBoxMenu (data110) then
		elif ListBoxMenu (data111) then
		elif ListBoxMenu (data112) then
		elif ListBoxMenu (data113) then
		elif ListBoxMenu (data114) then
		elif ListBoxMenu (data115) then
		elif ListBoxMenu (data116) then
		elif ListBoxMenu (data117) then
		elif ListBoxMenu (data118) then
		elif ListBoxMenu (data119) then
		elif ListBoxMenu (data120) then
		elif ListBoxMenu (data121) then
		elif ListBoxMenu (data122) then
		elif ListBoxMenu (data123) then
		elif ListBoxMenu (data124) then
		elif ListBoxMenu (data125) then
		elif ListBoxMenu (data126) then
		elif ListBoxMenu (data127) then
		elif ListBoxMenu (data128) then
		elif ListBoxMenu (data129) then
		elif ListBoxMenu (data130) then
		elif ListBoxMenu (data131) then
		elif ListBoxMenu (data132) then
		elif ListBoxMenu (data133) then
		elif ListBoxMenu (data134) then
		elif ListBoxMenu (data135) then
		elif ListBoxMenu (data136) then
		elif ListBoxMenu (data137) then
		elif ListBoxMenu (data138) then
		elif ListBoxMenu (data139) then
		elif ListBoxMenu (data140) then
		elif ListBoxMenu (data141) then
		elif ListBoxMenu (data142) then
		elif ListBoxMenu (data143) then
		elif ListBoxMenu (data144) then
		elif ListBoxMenu (data145) then
		elif ListBoxMenu (data146) then
		elif ListBoxMenu (data147) then
		elif ListBoxMenu (data148) then
		elif ListBoxMenu (data149) then
		elif ListBoxMenu (data150) then

		else
			SayString ("Menu of list boxes not created!")
			SayString ("You need to be in the variables list in a dialogue with arrow buttons to do this")
			PerformScript ScreenSensitiveHelp()
		endif
	else
			SayString ("You cannot use this function with the menus active!")
	endif

EndScript

Void Function FocusChangedEvent (handle FocusWindow, handle PrevWindow)
; this procedure is used to produce automatic speaking of arrow buttons and pat buttons

Var
	string ARText

	if GetWindowClass (GetFocus ()) == "ArrowButton" then
			Let WindowTitle = GetWindowName (GetRealWindow (GetFocus ()))
			Let FocusID = GetControlID (GetFocus ()) 
	
; the SpeakArrowButton routine returns true if it speaks. This curious if statement ensures that once the button is spoken 
; no more tests are done as it drops out the if statement

			if SpeakArrowButton (data1) then		
			elif SpeakArrowButton (data2) then 
			elif SpeakArrowButton (data3) then 
			elif SpeakArrowButton (data4) then 
			elif SpeakArrowButton (data5) then 
			elif SpeakArrowButton (data6) then 
			elif SpeakArrowButton (data7) then 
			elif SpeakArrowButton (data8) then 
			elif SpeakArrowButton (data9) then 
			elif SpeakArrowButton (data10) then 
			elif SpeakArrowButton (data11) then 
			elif SpeakArrowButton (data12) then 
			elif SpeakArrowButton (data13) then 
			elif SpeakArrowButton (data14) then 
			elif SpeakArrowButton (data15) then 
			elif SpeakArrowButton (data16) then 
			elif SpeakArrowButton (data17) then 
			elif SpeakArrowButton (data18) then 
			elif SpeakArrowButton (data19) then 
			elif SpeakArrowButton (data20) then 
			elif SpeakArrowButton (data21) then 
			elif SpeakArrowButton (data22) then 
			elif SpeakArrowButton (data23) then 
			elif SpeakArrowButton (data24) then 
			elif SpeakArrowButton (data25) then 
			elif SpeakArrowButton (data26) then
			elif SpeakArrowButton (data27) then
			elif SpeakArrowButton (data28) then
			elif SpeakArrowButton (data29) then
			elif SpeakArrowButton (data30) then
			elif SpeakArrowButton (data31) then
			elif SpeakArrowButton (data32) then
			elif SpeakArrowButton (data33) then
			elif SpeakArrowButton (data33) then
			elif SpeakArrowButton (data34) then
			elif SpeakArrowButton (data35) then
			elif SpeakArrowButton (data36) then
			elif SpeakArrowButton (data37) then
			elif SpeakArrowButton (data38) then
			elif SpeakArrowButton (data39) then
			elif SpeakArrowButton (data40) then
			elif SpeakArrowButton (data41) then
			elif SpeakArrowButton (data42) then
			elif SpeakArrowButton (data43) then
			elif SpeakArrowButton (data44) then
			elif SpeakArrowButton (data45) then
			elif SpeakArrowButton (data46) then
			elif SpeakArrowButton (data47) then
			elif SpeakArrowButton (data48) then
			elif SpeakArrowButton (data49) then
			elif SpeakArrowButton (data50) then
			elif SpeakArrowButton (data51) then
			elif SpeakArrowButton (data52) then
			elif SpeakArrowButton (data53) then
			elif SpeakArrowButton (data54) then
			elif SpeakArrowButton (data55) then
			elif SpeakArrowButton (data56) then
			elif SpeakArrowButton (data57) then
			elif SpeakArrowButton (data58) then
			elif SpeakArrowButton (data59) then
			elif SpeakArrowButton (data60) then
			elif SpeakArrowButton (data61) then
			elif SpeakArrowButton (data62) then
			elif SpeakArrowButton (data63) then
			elif SpeakArrowButton (data64) then
			elif SpeakArrowButton (data65) then
			elif SpeakArrowButton (data66) then
			elif SpeakArrowButton (data67) then
			elif SpeakArrowButton (data68) then
			elif SpeakArrowButton (data69) then
			elif SpeakArrowButton (data70) then
			elif SpeakArrowButton (data71) then
			elif SpeakArrowButton (data72) then
			elif SpeakArrowButton (data73) then
			elif SpeakArrowButton (data74) then
			elif SpeakArrowButton (data75) then
			elif SpeakArrowButton (data76) then
			elif SpeakArrowButton (data77) then
			elif SpeakArrowButton (data78) then
			elif SpeakArrowButton (data79) then
			elif SpeakArrowButton (data80) then
			elif SpeakArrowButton (data81) then
			elif SpeakArrowButton (data82) then
			elif SpeakArrowButton (data83) then
			elif SpeakArrowButton (data84) then
			elif SpeakArrowButton (data85) then
			elif SpeakArrowButton (data86) then
			elif SpeakArrowButton (data87) then
			elif SpeakArrowButton (data88) then
			elif SpeakArrowButton (data89) then
			elif SpeakArrowButton (data90) then
			elif SpeakArrowButton (data91) then
			elif SpeakArrowButton (data92) then
			elif SpeakArrowButton (data93) then
			elif SpeakArrowButton (data94) then
			elif SpeakArrowButton (data95) then
			elif SpeakArrowButton (data96) then
			elif SpeakArrowButton (data97) then
			elif SpeakArrowButton (data98) then
			elif SpeakArrowButton (data99) then
			elif SpeakArrowButton (data100) then
			elif SpeakArrowButton (data101) then
			elif SpeakArrowButton (data102) then
			elif SpeakArrowButton (data103) then
			elif SpeakArrowButton (data104) then
			elif SpeakArrowButton (data105) then
			elif SpeakArrowButton (data106) then
			elif SpeakArrowButton (data107) then
			elif SpeakArrowButton (data108) then
			elif SpeakArrowButton (data109) then
			elif SpeakArrowButton (data110) then
			elif SpeakArrowButton (data111) then
			elif SpeakArrowButton (data112) then
			elif SpeakArrowButton (data113) then
			elif SpeakArrowButton (data114) then
			elif SpeakArrowButton (data115) then
			elif SpeakArrowButton (data116) then
			elif SpeakArrowButton (data117) then
			elif SpeakArrowButton (data118) then
			elif SpeakArrowButton (data119) then
			elif SpeakArrowButton (data120) then
			elif SpeakArrowButton (data121) then
			elif SpeakArrowButton (data122) then
			elif SpeakArrowButton (data123) then
			elif SpeakArrowButton (data124) then
			elif SpeakArrowButton (data125) then
			elif SpeakArrowButton (data126) then
			elif SpeakArrowButton (data127) then
			elif SpeakArrowButton (data128) then
			elif SpeakArrowButton (data129) then
			elif SpeakArrowButton (data130) then
			elif SpeakArrowButton (data131) then
			elif SpeakArrowButton (data132) then
			elif SpeakArrowButton (data133) then
			elif SpeakArrowButton (data134) then
			elif SpeakArrowButton (data135) then
			elif SpeakArrowButton (data136) then
			elif SpeakArrowButton (data137) then
			elif SpeakArrowButton (data138) then
			elif SpeakArrowButton (data139) then
			elif SpeakArrowButton (data140) then
			elif SpeakArrowButton (data141) then
			elif SpeakArrowButton (data142) then
			elif SpeakArrowButton (data143) then
			elif SpeakArrowButton (data144) then
			elif SpeakArrowButton (data145) then
			elif SpeakArrowButton (data146) then
			elif SpeakArrowButton (data147) then
			elif SpeakArrowButton (data148) then
			elif SpeakArrowButton (data149) then
			elif SpeakArrowButton (data150) then

			else
				SayString ("Arrow button " +IntToString(FocusID)+" not labelled in dialogue "+ WindowTitle )
			endif
	endif

	if GetWindowClass (GetFocus ()) == "PatButton" then
		Let WindowTitle = GetWindowName (GetRealWindow (GetFocus ()))
		Let FocusID = GetControlID (GetFocus ()) 

;* Bar chart dialogue
; the speakPatButton routine returns true if it speaks. This curious if statement ensures that once the button is spoken 
; no more tests are done

		if SpeakPatButton("Bar charts" ,100,"simple bar chart selected") then ; found button
		elif SpeakPatButton("Bar charts" ,101,"clustered bar chart selected") then ; found button
		elif SpeakPatButton("Bar charts" ,102,"stacked bar chart selected") then ; found button
		elif SpeakPatButton("Line charts" ,100,"simple line chart selected") then ; found button
		elif SpeakPatButton("Line charts" ,101,"multiple line chart selected") then ; found button
		elif SpeakPatButton("Line charts" ,102,"drop line chart selected") then ; found button
		elif SpeakPatButton("Area charts" ,100,"simple area chart selected") then ; found button
		elif SpeakPatButton("Area charts" ,101,"stacked area chart selected") then ; found button
		elif SpeakPatButton("High-Low charts" ,100,"simple High Low close chart selected") then ; found button
		elif SpeakPatButton("High-Low charts" ,101,"clustered High Low close chart selected") then ; found button
		elif SpeakPatButton("High-Low charts" ,102,"simple range bar selected") then ; found button
		elif SpeakPatButton("High-Low charts" ,103,"clustered range bar selected") then ; found button
		elif SpeakPatButton("High-Low charts" ,104,"difference line chart selected") then ; found button
		elif SpeakPatButton("Pareto charts" ,100,"simple pareto chart selected") then ; found button
		elif SpeakPatButton("Pareto charts" ,101,"stacked pareto chart selected") then ; found button
		elif SpeakPatButton("Control charts" ,100,"X bar, r, s control chart selected") then ; found button
		elif SpeakPatButton("Control charts" ,101,"individuals, moving range control chart selected") then ; found button
		elif SpeakPatButton("Control charts" ,102,"p n p control chart selected") then ; found button
		elif SpeakPatButton("Control charts" ,103,"c u control chart selected") then ; found button
		elif SpeakPatButton("Boxplot" ,100,"simple Box plot chart selected") then ; found button
		elif SpeakPatButton("Boxplot" ,101,"clustered Box plot chart selected") then ; found button
		elif SpeakPatButton("Error bar" ,100,"simple Error bar chart selected") then ; found button
		elif SpeakPatButton("Error bar" ,101,"clustered Error bar chart selected") then ; found button
		elif SpeakPatButton("Scatterplot" ,100,"simple Scatterplot selected") then ; found button
		elif SpeakPatButton("Scatterplot" ,101,"overlay Scatterplot selected") then ; found button
		elif SpeakPatButton("Scatterplot" ,102,"matrix Scatterplot selected") then ; found button
		elif SpeakPatButton("Scatterplot" ,103,"3 d Scatterplot selected") then ; found button
		else
			SayString ("Pat button " +IntToString(FocusID)+" not labelled in dialogue "+ WindowTitle )
		endif
	endif

; Perform the focus changed event script
	FocusChangedEvent (FocusWindow, PrevWindow)

EndFunction

Script MoveToOKButton ()
; invoked with insert + o

Var
	handle StartPoint,
	int StopIt, 
	int HitBottom,
	int safety

	if DialogActive () && not MenusActive () then
		let StartPoint = GetCurrentWindow ()
		SaveCursor ()
		MoveToWindow (GetRealWindow (GetCurrentWindow ()))
		MoveToWindow (GetFirstChild (GetCurrentWindow ()))
		let safety = 0
		let StopIt = false
		while not StopIt
			let safety = safety + 1
			MoveToWindow (GetNextWindow (GetCurrentWindow ()))
			if GetWindowClass (GetCurrentWindow ()) == "Button" &&
			  GetWindowText (GetCurrentWindow (), false) == "OK" then
				let HitBottom = false
				let StopIt = true
				if IsWindowDisabled (GetCurrentWindow ()) then
					SayString ("The OK button is greyed")
				else
					SetFocus (GetCurrentWindow ())
				endif
			endif
			if (safety >= 100) then
				let StopIt = true
				SayString ("Could not jump to the OK button. There may be a control in the ")
				SayString ("dialogue that prevents the script from jumping there, or there may ")
				SayString ("be no OK button here. Try moving there using the tab key.")
				MoveToWindow (StartPoint)
				SetFocus (GetCurrentWindow ())
			endif
		endwhile
		RestoreCursor ()
	endif
EndScript


Int Function MoveToArrowButton (int direction, int SpeechOn)
; Called by Next and PreviousArrowButton routines

Var
	handle StartPoint,
	int StopIt, 
	int HitBottom,
	int safety

	if DialogActive () && not MenusActive () then
		SaveCursor ()
		let StartPoint = GetCurrentWindow ()
		MoveToWindow (GetCurrentWindow ())
		while not StopIt
			let safety = safety + 1
			if direction == 1 then 
				MoveToWindow (GetNextWindow (GetCurrentWindow ()))
			else
				MoveToWindow (GetPriorWindow (GetCurrentWindow ()))
			endif
			if GetWindowClass (GetCurrentWindow ()) == "ArrowButton" then
				let HitBottom = false
				let StopIt = true
				SetFocus (GetCurrentWindow ())
			endif
			if (safety >= 100) then
				let StopIt = true
				if direction == 1 then 
					if SpeechOn then
						SayString ("No more arrow buttons. Use Insert P for previous buttons")
					endif
				else
					if SpeechOn then
						SayString ("No previous arrow buttons. Use Insert N for next buttons")
					endif
				endif
				JAWSPageUp ()
				JAWSHome ()
			endif
		endwhile
	endif

EndFunction

Script NextArrowButton ()
;Moves to the next arrow button in the dialogue. Complemented by PreviousArrowButton.
	MoveToArrowButton(1,1)
EndScript

Script PreviousArrowButton ()
; Moves to the previous arrow button in the dialogue. Complemented by NextArrowButton.
	MoveToArrowButton(0,1)
EndScript

; *** Output Navigator

Int Function InOutputNavigator ()
; This function tests to see if the user is in the Output Navigator. 
; the first condition is for the right window open
; the second that we are not in a menu
; the third that we are not in a dialogue
	if (StringContains (GetWindowName (GetAppMainWindow (getfocus())), "Output Navigator")  || ; version 7.5
	   StringContains (GetWindowName (GetAppMainWindow (getfocus())), "SPSS Viewer")   ||  ; version 8
	   StringContains (GetWindowName (GetAppMainWindow (getfocus())), "SPSS for Windows Viewer"))  && ; version 9
	   (MenusActive () == False) &&
	   (DialogActive () == False) then
		Return 1
	else
		Return  0
	endif
EndFunction

Script FindArrow ()
; Attempts to find the navigator arrow. If it is succesfully located, then a mouse click will select the appropriate levels
; so that they are then spoken.

	if InOutputNavigator () then
		FindGraphic (GetAppMainWindow (GetCurrentWindow ()), "SPSSNavArrow", S_TOP, S_UNRESTRICTED)
		if StringContains (GetWord () , "SPSSNavArrow") then
			LeftMouseButton ()
			StopSpeech ()
			PCCursor()
		else
			StopSpeech ()
			PCCursor()
			SayString ("Could not locate the navigation arrow")
			SayString ("You may need to switch the outline size to medium.")
			SayString ("You can do this with Alt V, Z, M.")
			SayString ("It may be that the left side of the window needs to be increased in width")
			SayString ("Which can only be done with the mouse.")
			SayString ("You can still look at your output in an editor.")
			SayString ("Use insert f 1 to find out how to do this.")
		endif
	endif

EndScript

Script SwitchHTMLMode ()
; ins m
	if HTMLMode == 0 then
		let HTMLMode = 1
		SayString ("Excel HTML mode. Tables will be exported as htm files and displayed in Excel")
	elif HTMLMode == 1 then
		let HTMLMode = 2
		SayString ("Word HTML mode. Tables will be exported as htm files and displayed in Word")
	else
		let HTMLMode = 0
		SayString ("Text mode. Tables will be exported as a t x t file and displayed in Wordpad")
	endif	
EndScript

Script WordpadLoadExportedText ()
	if InOutputNavigator () then
		SayString ("Loading exported text into editor")
		
		Run ("write c:/mydocu~1/output.txt")
	endif
EndScript

Void Function ExcelLoadExportedText ()
; runs excel loading the exported table (requires my documents folder to be the default location for files in Excel)

	if InOutputNavigator () then
		SayString ("Loading exported text into excel")
		Run ("excel /e output.htm")
	endif
EndFunction

Void Function WordLoadExportedText ()
	if InOutputNavigator () then
		SayString ("Loading exported text into word")
		Run ("winword c:/mydocu~1/output.htm")
	endif
EndFunction

Script LoadOutputIntoEditor ()
	if HTMLmode == 0 then
		PerformScript WordpadLoadExportedText ()
	elif HTMLmode == 1 then
		ExcelLoadExportedText()
	else
		WordLoadExportedText()
	endif

EndScript

Script AutomatedExport ()
; enters the keystrokes to export the current output in the navigator window to an external file.

Var
	int OutputWhat

	if InOutputNavigator () then
		
		if HTMLmode == 1 then
			Let OutputWhat = DlgSelectItemInList ("Last output|Selected items|All output", 
						"Output what items to Excel?", False)
		elif HTMLmode == 2 then
			Let OutputWhat = DlgSelectItemInList ("Last output|Selected items|All output", 
						"Output what items to Word?", False)
		else
			Let OutputWhat = DlgSelectItemInList ("Last output|Selected items|All output",  
						"Output what items to text editor?", False)
		endif

		if OutputWhat == 1 then
			{Alt-E}					; edit menu
			{L}					; select sub menu
			{L}					; last output item
		endif
		if OutputWhat == 2 then
;			no change needed to selection
		endif
		if OutputWhat == 3 then
			{Alt-E}					; edit menu
			{A}					; select all 
		endif
		if OutputWhat != 0 then
			StopSpeech ()
			SpeechOff ()
			{Alt-F} {t} 				;export dialogue
			{Alt-F}					; filename edit box
			{Delete}
			TypeString ("c:/mydocu~1/output")	; enter filename NB used / as \ causes Jaws bug
			pause()
			{Alt-D}					; set to selected items
			if HTMLmode then
				{Alt-T} {h}			; set to html format
			else
				{Alt-T} {t}			; set to text format
			endif
			SpeechOn ()
			{enter}
			Pause ()
			Pause ()
			if (GetWindowName (GetParent(GetFocus ()))) == "File overwrite confirmation" then 
				{space} ; confirm yes
				Pause ()
				StopSpeech ()
				SayString ("OK!")
			endif
		endif
	endif
EndScript
